/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : tardefs.h
************************************************************************
* Written by    : Christian Zurhorst, BID R&D, 2.2.98
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h 
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef TARDEFS_H_INCLUDED                               
#define TARDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif



/* ---------------------------------------------------------------
 * Type Definitions for Target Functions
 * --------------------------------------------------------------- */


#define B_TATTRPROP_SIZE	12
/* Caution:
   If you add or remove a property here or change its group,
   do not forget to adjust files dynamic.c and  prp_tatt.c 
   (function Prop2Group()) also.
 */ 
CLI typedef enum {
  B_T_DOLOOP,         /* @loop */     /* Group 1 */
  B_T_TERM,           /* @term */     /* Group 3 */
  B_T_WAITS,          /* @w */        /* Group 2 */
  B_T_DPERR,          /* @dperr */    /* Group 3 */
  B_T_DSERR,          /* @dserr */    /* Group 3 */
  B_T_APERR,          /* @aperr */    /* Group 1 */
  B_T_WRPAR,          /* @wp */       /* Group 3 */
  B_T_ACK64,          /* @ack64 */    /* Group 1 */
  B_T_DACPERR,        /* @dacperr */  /* Group 1 */
  B_T_WRPAR64,        /* @wp64    */  /* Group 3 */
  B_T_MARKER,         /* @mark */     /* Group 4 */ 
  B_T_REPEAT          /* @repeat */   /* Group 5 */
} b_tattrproptype;
/* the property WAITMODE is not yet included (this feature is not 
 * supported in the first cut of the e2920 PCI series software) */


#define B_TATTR_GRP_NUM		   5
   
/* target attribute group structure */
/* group organization
   
  B_TATTR_GRP_TA0
       aperr
    ** E2926
       ack64
       dacperr
  
  B_TATTR_GRP_TD0
       waits
    ** E2925
       term
  
  B_TATTR_GRP_TD1
       dperr
       dserr
       wrpar
    ** E2926
       term
       wrpar64
  
  B_TATTR_GRP_TD2
    ** E2926 only
       marker
  
  B_TATTR_GRP_TC	  // control group
       loop
    ** E2926
       repeat

*/

CLI typedef enum {
  B_TATTR_GRP_TA0, /* @tagrpa0 */
  B_TATTR_GRP_TD0, /* @tagrpd0 */
  B_TATTR_GRP_TD1, /* @tagrpd1 */
  B_TATTR_GRP_TD2, /* @tagrpd2 */
  B_TATTR_GRP_TC   /* @tagrpc  */
} b_tattrgrouptype;


#define B_TGENPROP_SIZE		 5

CLI typedef enum {
  B_TGEN_RUNMODE,      /* @runmode   */
  B_TGEN_MEMSPACE,     /* @memspace  */
  B_TGEN_IOSPACE,      /* @iospace   */
  B_TGEN_ROMENABLE,    /* @romenable */
  B_TGEN_BACKCAPABLE   /* @back_capa */
} b_targetgenproptype;


/* ---------------------------------------------------------------
 * Defines for Target Functions
 * --------------------------------------------------------------- */

CLI /* DEF_START ~G_TargetTerm ~~B_T_TERM */
#define B_TERM_NOTERM           0x0  /* @noterm */
#define B_TERM_RETRY            0x1  /* @retry  */
#define B_TERM_DISCONNECT       0x2  /* @discon @disconnect */
#define B_TERM_ABORT            0x3  /* @abort  */
CLI /* DEF_END */

CLI /* DEF_START ~G_TargetRunmode */
#define B_RUNMODE_ADDRRESTART   0x0  /* @addrrestart */
#define B_RUNMODE_SEQUENTIAL    0x1  /* @sequential */
CLI /* DEF_END */

CLI /* DEF_START ~G_TargetWaits ~~B_T_WAITS */
#define B_T_WAITS_HANG   0xFFFFFFFF /* @whang */
CLI /* DEF_END */

/* --------------------------------------------------------------------------
 * Definitions for the EEPROM
 * -------------------------------------------------------------------------- */

/* possible values for b_boardproptype:B_BOARD_ROMUSAGE */
CLI /* DEF_START ~G_TargetRomusage */
#define B_ROMUSAGE_EXTERNAL         0x0  /* @external */
#define B_ROMUSAGE_INTERNAL         0x1  /* @internal */
CLI /* DEF_END */

#endif



